library(robust)
library(MASS)

phones.lm <- lm(calls ~ year, data = phones)
with(phones, plot(year, calls))

abline(phones.lm$coef, col = "red")
abline(rlm(calls ~ year, phones, maxit=50), col = "blue")
abline(lqs(calls ~ year, phones), col = "green")
legend(52.5, 200, col = c("red", "blue", "green"), 
	background = "transparent", lwd = 2, bty = "n",
   legend = c("least squares", "M-estimate", "LTS"))

with(animals, {
	plot(log(Body), log(Brain))
	identify(log(Body), log(Brain), Name)
})

abline(lm(log(Brain) ~ log(Body), animals), col = "red")
abline(lmRob(log(Brain) ~ log(Body), animals), col = "blue")
abline(rlm(log(Brain) ~ log(Body), animals, method = "MM"), col = "green")

legend(-5, 8, c("Least squares", "lmRob defaults", "rlm, method MM"),
	col = c("red", "blue", "green"),lwd = 2, background = "transparent",
	bty = "n")
	
anim.lmR <- lmRob(log(Brain) ~ log(Body), animals)
wt <- round(anim.lmR$M.weights, 2)
attach(animals); plot(log(Body), log(Brain))
identify(log(Body), log(Brain), as.character(wt), cex = 1.5, col = 2)
detach()

graphics.off()

xyplot(log(Weight) ~ log(Length) | Species*Sex, LWData)

LWData <- transform(LWData,
	SS = factor(paste(substring(Species, 1, 5), 
						  substring(Sex, 1, 1), sep="-")))
						
prawns.lm1 <- lmList(log(Weight) ~ log(Length) | SS, LWData)
round(summary(prawns.lm1)$coef, 4)

prawns.lm2 <- lm(log(Weight) ~ SS/log(Length) - 1, LWData)
round(summary(prawns.lm2)$coef, 4)

prawns.lmR <- lmRob(log(Weight) ~ SS/log(Length) - 1, LWData)
summary(prawns.lmR, cor=F)$coef

wt <- prawns.lmR$M.weights
wtf <- factor(ifelse(wt == 0, 0, ifelse(wt < 1, 0.5, 1)))
table(wtf)

xyplot(abs(resid(prawns.lmR))^0.25 ~ fitted(prawns.lmR) | Sex*Species,
	LWData, groups = wtf, panel = panel.superpose, as.table = T,
	key = list(columns = 3, background = 16, points = list(pch = 1, col = 2:4),
	text = list(c("Zero", "Intermediate", "Full"), col = 2:4)))
	
xyplot(log(Weight) ~ log(Length) | Sex*Species*wtf, LWData,
	layout = c(2,2))